cd "$master"
clear

use input\facility_raw, clear
destring FacilityName, replace
duplicates report FacilityName
rename FacilityName code

destring sectionA_SeniorClinician, replace
g senior_cadre=sectionA_SeniorClinician
label define cadre 1 "Doctor or medical officer" 2 "Assistant medical officer" 3 "Clinical officer" 4 "Nurse or midwife"  5 "Other"
label values senior_cadre cadre
* Replace senior_cadre based on response in a text field that can't be shown to maintain anonymity
replace senior_cadre=1 if code==216
replace senior_cadre=1 if code==198

destring sectionA_InCharge, replace
g in_charge=sectionA_InCharge
label define incharge 1 "Senior clinician is the in-charge" 2 "Other clinican is the in-charge" 3 "Administrator/non-clinician is the in-charge" 4 "Responsibility shared by clinician and non-clinician"
label values in_charge incharge
g clinician_incharge=(in_charge<=2) if in_charge!=.
g incharge_type=1 if clinician_incharge==1
replace incharge_type=2 if in_charge==3
replace incharge_type=3 if in_charge==4
label define incharge_type 1 "Clinician" 2 "Administrator" 3 "Both clinician and administrator" 
label values incharge_type incharge_type

** Defining management measures       
g mngmt_triage=sectionB_manageA_triageask
g mngmt_record=sectionB_manageA_recordsask
g mngmt_mtuha=sectionB_manageA_mtuhaask
g mngmt_patind=sectionB_manageA_patindsask
g mngmt_freqpat=sectionB_manageB_freqpatindsask
g mngmt_busind=sectionB_manageB_busindsask
g mngmt_freqbus=sectionB_manageC_freqbusindsask
g mngmt_target=sectionB_manageD_targetask
g mngmt_training=sectionB_manageE_trainask
g mngmt_pay=sectionB_manageE_payask
replace mngmt_pay="2" if mngmt_pay=="1 2"
replace mngmt_pay="3" if mngmt_pay=="1 3"
replace mngmt_pay="4" if mngmt_pay=="1 4"
replace mngmt_pay="4" if mngmt_pay=="2 4"
g mngmt_appraise=sectionB_manageE_appraisalask
g mngmt_inventory=sectionB_manageF_inventask
g mngmt_budget=sectionB_manageF_budgetask
g mngmt_profit=sectionB_manageF_profitask

destring mngmt_triage mngmt_record mngmt_mtuha mngmt_patind mngmt_freqpat mngmt_busind mngmt_freqbus mngmt_target mngmt_training mngmt_pay mngmt_appraise mngmt_inventory mngmt_budget mngmt_profit, replace

recode mngmt_triage (2=0.5) (3=0)
recode mngmt_record (2=0.5) (3=0)
recode mngmt_mtuha (2=0)
recode mngmt_patind (4=0) (1=0.333) (2=0.667) (3=1)
recode mngmt_freqpat (.=0) (5=0) (1=0.25) (2=0.5) (3=0.75) (4=1)
recode mngmt_busind (4=0) (1=0.333) (2=0.667) (3=1)
recode mngmt_freqbus (.=0) (5=0) (1=0.25) (2=0.5) (3=0.75) (4=1)
recode mngmt_target (4=0) (1=0.333) (2=0.667) (3=1)
recode mngmt_training (2=0.5) (3=0)
recode mngmt_pay (1=0) (2=0.333) (3=0.667) (4=1)
recode mngmt_appraise (2=0)
recode mngmt_inventory (4=0) (2=0.667) (3=0.333)
recode mngmt_budget (2=0)
recode mngmt_profit (2=0)

egen mngmt_score1=rowmean(mngmt_triage mngmt_record mngmt_mtuha mngmt_patind mngmt_freqpat mngmt_busind mngmt_freqbus mngmt_target mngmt_training  mngmt_appraise mngmt_inventory mngmt_budget mngmt_profit)
egen mngmt_score2=rowtotal(mngmt_triage mngmt_record mngmt_mtuha mngmt_patind mngmt_freqpat mngmt_busind mngmt_freqbus mngmt_target mngmt_training  mngmt_appraise mngmt_inventory mngmt_budget mngmt_profit)

recode mngmt_triage (0.5=0) (3=0)
recode mngmt_record (0.5=1) (3=0)
recode mngmt_mtuha (2=0)
recode mngmt_patind (4=0) (1=0.333) (2=0.667) (3=1)
recode mngmt_freqpat (.=0) (5=0) (1=0.25) (2=0.5) (3=0.75) (4=1)
recode mngmt_busind (4=0) (1=0.333) (2=0.667) (3=1)
recode mngmt_freqbus (.=0) (5=0) (1=0.25) (2=0.5) (3=0.75) (4=1)
recode mngmt_target (4=0) (1=1) (2=1) (3=1)
recode mngmt_training (0.5=1) (3=0)
recode mngmt_pay (1=0) (2=0.333) (3=0.667) (4=1)
recode mngmt_appraise (2=0)
recode mngmt_inventory (4=0) (0.667=1) (0.333=1)
recode mngmt_budget (2=0)
recode mngmt_profit (2=0)

egen mngmt_score1_v2=rowmean(mngmt_triage mngmt_record mngmt_mtuha mngmt_patind mngmt_freqpat mngmt_busind mngmt_freqbus mngmt_target mngmt_training  mngmt_appraise mngmt_inventory mngmt_budget mngmt_profit)
egen mngmt_score2_v2=rowtotal(mngmt_triage mngmt_record mngmt_mtuha mngmt_patind mngmt_freqpat mngmt_busind mngmt_freqbus mngmt_target mngmt_training  mngmt_appraise mngmt_inventory mngmt_budget mngmt_profit)

g mngmt_triage_obs=sectionE_manobsa_triageobs
g mngmt_record_obs=sectionE_manobsa_recordsobs
g mngmt_mtuha_obs=sectionE_manobsa_mtuhaobs
g mngmt_patind_obs=sectionE_patindsobs
g mngmt_freqpat_obs=sectionE_freqpatindobs
g mngmt_busind_obs=sectionE_busindsobs
g mngmt_freqbus_obs=sectionE_freqbusindobs
g mngmt_target_obs=sectionE_manobsb_targetobs
g mngmt_training_obs=sectionE_manobsb_trainobs
g mngmt_appraise_obs=sectionE_manobsb_appraisalobs
g mngmt_inventory_obs=sectionE_manobsb_inventobs
g mngmt_budget_obs=sectionE_manobsb_budgetobs
g mngmt_profit_obs=sectionE_manobsb_profitobs

destring mngmt_triage_obs mngmt_record_obs mngmt_mtuha_obs mngmt_patind_obs mngmt_freqpat_obs mngmt_busind_obs mngmt_freqbus_obs mngmt_target_obs mngmt_training_obs mngmt_appraise_obs mngmt_inventory_obs mngmt_budget_obs mngmt_profit_obs, replace

recode mngmt_triage_obs (2=0) (.=0)
recode mngmt_record_obs (2=0) (.=0)        
recode mngmt_mtuha_obs (2=0) (.=0) 
recode mngmt_patind_obs (4=0) (1=0.333) (2=0.667) (3=1) (.=0)
recode mngmt_freqpat_obs (.=0) (5=0) (1=0.25) (2=0.5) (3=0.75) (4=1)
recode mngmt_busind_obs (4=0) (1=0.333) (2=0.667) (3=1) (.=0)
recode mngmt_freqbus_obs (.=0) (5=0) (1=0.25) (2=0.5) (3=0.75) (4=1)
recode mngmt_target_obs (2=0) (.=0)
recode mngmt_training_obs (2=0) (.=0)
recode mngmt_appraise_obs (2=0)  (.=0)
recode mngmt_inventory_obs (2=0) (.=0)
recode mngmt_budget_obs (2=0) (.=0)
recode mngmt_profit_obs (2=0) (.=0)

egen mngmt_score_obs1=rowmean(mngmt_triage_obs mngmt_record_obs mngmt_mtuha_obs mngmt_patind_obs mngmt_freqpat_obs mngmt_busind_obs mngmt_freqbus_obs mngmt_target_obs mngmt_training_obs mngmt_appraise_obs mngmt_inventory_obs mngmt_budget_obs mngmt_profit_obs)
egen mngmt_score_obs2=rowtotal(mngmt_triage_obs mngmt_record_obs mngmt_mtuha_obs mngmt_patind_obs mngmt_freqpat_obs mngmt_busind_obs mngmt_freqbus_obs mngmt_target_obs mngmt_training_obs mngmt_appraise_obs mngmt_inventory_obs mngmt_budget_obs mngmt_profit_obs)
egen mngmt_patient_obs1=rowmean(mngmt_triage_obs mngmt_record_obs mngmt_inventory_obs mngmt_training_obs)
egen mngmt_nonpatient_obs1=rowmean(  mngmt_mtuha_obs mngmt_patind_obs mngmt_freqpat_obs mngmt_busind_obs mngmt_freqbus_obs mngmt_target_obs mngmt_appraise_obs  mngmt_budget_obs mngmt_profit_obs)
xtile mngmt_obs_nq5=mngmt_score_obs1, nq(5)
factor mngmt_triage_obs-mngmt_profit_obs, pcf
predict mngmt_score_obs_pcf

foreach var of varlist mngmt_triage_obs-mngmt_profit_obs {
sum `var'
scalar average=r(mean)
scalar sd=r(sd)
g z_`var'=(`var'-average)/sd
}
sum z*
egen z_mngmt_score_obs=rowmean(z_mngmt_triage_obs-z_mngmt_profit_obs)
foreach var of varlist z_mngmt_score_obs {
sum `var'
scalar average=r(mean)
scalar sd=r(sd)
replace `var'=(`var'-average)/sd
}
drop z_mngmt_triage_obs- z_mngmt_profit_obs


* Utilisation outcomes
g opd_m1=registers_OPD_opdpage1_OPD1
destring opd_m1, replace
recode opd_m1 (9999=.)
g opd_m2=registers_OPD_opdpage2_OPD2
destring opd_m2, replace
recode opd_m2 (9999=.)
g opd_m3=registers_OPD_opdpage2_OPD3
destring opd_m3, replace
recode opd_m3 (9999=.)

g ipd_m1=registers_IPD_ipdpage1_IPD1
destring ipd_m1, replace
recode ipd_m1 (9999=.)
g ipd_m2=registers_IPD_ipdpage2_IPD2
destring ipd_m2, replace
recode ipd_m2 (9999=.)
g ipd_m3=registers_IPD_ipdpage2_IPD3
destring ipd_m3, replace
recode ipd_m3 (9999=.)

g ctc_m1=registers_CTC_ctcpage1_CTC1
destring ctc_m1, replace
recode ctc_m1 (9999=.)
g ctc_m2=registers_CTC_ctcpage2_CTC2
destring ctc_m2, replace
recode ctc_m2 (9999=.)
g ctc_m3=registers_CTC_ctcpage2_CTC3
destring ctc_m3, replace
recode ctc_m3 (9999=.)

g tb_m1=registers_TB__tbpage1_TB_1
destring tb_m1, replace
recode tb_m1 (9999=.)
g tb_m2=registers_TB__tbpage2_TB_2
destring tb_m2, replace
recode tb_m2 (9999=.)
g tb_m3=registers_TB__tbpage2_TB_3
destring tb_m3, replace
recode tb_m3 (9999=.)

g anc_m1=registers_ANC_ancpage1_ANC1
destring anc_m1, replace
recode anc_m1 (9999=.)
g anc_m2=registers_ANC_ancpage2_ANC2
destring anc_m2, replace
recode anc_m2 (9999=.)
g anc_m3=registers_ANC_ancpage2_ANC3
destring anc_m3, replace
recode anc_m3 (9999=.)

g del_m1=registers_Del_delpage1_Del1
destring del_m1, replace
recode del_m1 (9999=.)
g del_m2=registers_Del_delpage2_Del2
destring del_m2, replace
recode del_m2 (9999=.)
g del_m3=registers_Del_delpage2_Del3
destring del_m3, replace
recode del_m3 (9999=.)

g fp_m1=registers_Fam_fppage1_Fam1
destring fp_m1, replace
recode fp_m1 (9999=.)
g fp_m2=registers_Fam_fppage2_Fam2
destring fp_m2, replace
recode fp_m2 (9999=.)
g fp_m3=registers_Fam_fppage2_Fam3
destring fp_m3, replace
recode fp_m3 (9999=.)

g dia_m1=registers_Dia_diapage1_Dia1
destring dia_m1, replace
recode dia_m1 (9999=.)
g dia_m2=registers_Dia_diapage2_Dia2
destring dia_m2, replace
recode dia_m2 (9999=.)
g dia_m3=registers_Dia_diapage2_Dia3
destring dia_m3, replace
recode dia_m3 (9999=.)

egen opd_mean=rowmean(opd_m1 opd_m2 opd_m3)
egen ipd_mean=rowmean(ipd_m1 ipd_m2 ipd_m3)
replace ipd_mean=0 if ipd_mean==.
egen ctc_mean=rowmean(ctc_m1 ctc_m2 ctc_m3)
egen tb_mean=rowmean(tb_m1 tb_m2 tb_m3)
egen anc_mean=rowmean(anc_m1 anc_m2 anc_m3)
egen del_mean=rowmean(del_m1 del_m2 del_m3)
egen fp_mean=rowmean(fp_m1 fp_m2 fp_m3)
egen dia_mean=rowmean(dia_m1 dia_m2 dia_m3)
egen visits_mean=rowtotal(opd_mean ipd_mean ctc_mean tb_mean anc_mean del_mean fp_mean dia_mean), missing
egen opd_all_mean=rowtotal(opd_mean  ctc_mean tb_mean anc_mean  fp_mean dia_mean), missing
egen ipd_all_mean=rowtotal( ipd_mean del_mean), missing

* Revenue outcomes
g cash_m1=revenue_Cash_cashpage1_Cash1
destring cash_m1, replace
recode cash_m1 (9999=.)
g cash_m2=revenue_Cash_cashpage2_Cash2
destring cash_m2, replace
recode cash_m2 (9999=.)
g cash_m3=revenue_Cash_cashpage2_Cash3
destring cash_m3, replace
recode cash_m3 (9999=.)

g insurance_m1=revenue_Insurance_insurancepage0
destring insurance_m1, replace
recode insurance_m1 (9999=.)
g insurance_m2=revenue_Insurance_insurancepage3
destring insurance_m2, replace
recode insurance_m2 (9999=.)
g insurance_m3=revenue_Insurance_insurancepage5
destring insurance_m3, replace
recode insurance_m3 (9999=.)

g gov_m1=revenue_Government_governmentpa0
destring gov_m1, replace
recode gov_m1 (9999=.)
g gov_m2=revenue_Government_governmentpa2
destring gov_m2, replace
recode gov_m2 (9999=.)
g gov_m3=revenue_Government_governmentpa4
destring gov_m3, replace
recode gov_m3 (9999=.)

g contract_m1=revenue_Contract_contractpage1_0
destring contract_m1, replace
recode contract_m1 (9999=.)
g contract_m2=revenue_Contract_contractpage2_C
destring contract_m2, replace
recode contract_m2 (9999=.)
g contract_m3=revenue_Contract_contractpage2_1
destring contract_m3, replace
recode contract_m3 (9999=.)

g mpesa_m1=revenue_Mobile_mpesapage1_Mpesa1
destring mpesa_m1, replace
recode mpesa_m1 (9999=.)
g mpesa_m2=revenue_Mobile_mpesapage2_Mpesa2
destring mpesa_m2, replace
recode mpesa_m2 (9999=.)
g mpesa_m3=revenue_Mobile_mpesapage2_Mpesa3
destring mpesa_m3, replace
recode mpesa_m3 (9999=.)

egen cash_mean=rowmean(cash_m1 cash_m2 cash_m3)
egen insurance_mean=rowmean(insurance_m1 insurance_m2 insurance_m3)
egen gov_mean=rowmean(gov_m1 gov_m2 gov_m3)
egen contract_mean=rowmean(contract_m1 contract_m2 contract_m3)
egen mpesa_mean=rowmean(mpesa_m1 mpesa_m2 mpesa_m3)
egen revenue_mean1=rowtotal(cash_mean insurance_mean gov_mean contract_mean mpesa_mean), missing
replace revenue_mean1=revenue_mean1*12/2264


keep code mngmt_score_obs1 mngmt_score_obs_pcf z_mngmt_score_obs mngmt_score1_v2 incharge_type opd_mean revenue_mean1 
save output\clean_facility, replace



